/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.model.battle;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import rpgboss.lib.Utils$;
import rpgboss.model.BaseStats;
import rpgboss.model.Encounter;
import rpgboss.model.EncounterUnit;
import rpgboss.model.Enemy;
import rpgboss.model.ItemDrop;
import rpgboss.model.ProjectData;
import rpgboss.model.battle.Battle$;
import rpgboss.model.battle.BattleAI;
import rpgboss.model.battle.BattleAction;
import rpgboss.model.battle.BattleActionNotification;
import rpgboss.model.battle.BattleEntityType$;
import rpgboss.model.battle.BattleStatus;
import rpgboss.model.battle.BattleStatus$;
import rpgboss.model.battle.Hit;
import rpgboss.model.battle.PartyParameters;
import rpgboss.model.battle.StatusEffectAction$;
import scala.Array$;
import scala.Enumeration;
import scala.Float$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric$FloatIsFractional$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005q!B\u0001\u0003\u0011\u0003I\u0011A\u0002\"biRdWM\u0003\u0002\u0004\t\u00051!-\u0019;uY\u0016T!!\u0002\u0004\u0002\u000b5|G-\u001a7\u000b\u0003\u001d\tqA\u001d9hE>\u001c8o\u0001\u0001\u0011\u0005)YQ\"\u0001\u0002\u0007\u000b1\u0011\u0001\u0012A\u0007\u0003\r\t\u000bG\u000f\u001e7f'\tYa\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+-!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%Aq\u0001G\u0006C\u0002\u0013\u0005\u0011$\u0001\u0004B\u0007RKe+R\u000b\u00025A\u0011qbG\u0005\u00039A\u00111!\u00138u\u0011\u0019q2\u0002)A\u00055\u00059\u0011i\u0011+J-\u0016\u0003\u0003b\u0002\u0011\f\u0005\u0004%\t!G\u0001\b-&\u001bEk\u0014*Z\u0011\u0019\u00113\u0002)A\u00055\u0005Aa+S\"U\u001fJK\u0006\u0005C\u0004%\u0017\t\u0007I\u0011A\r\u0002\r\u0011+e)R!U\u0011\u001913\u0002)A\u00055\u00059A)\u0012$F\u0003R\u0003\u0003b\u0002\u0015\f\u0005\u0004%\t!G\u0001\b\u000bN\u001b\u0015\tU#E\u0011\u0019Q3\u0002)A\u00055\u0005AQiU\"B!\u0016#\u0005E\u0002\u0003\r\u0005\u0001a3cA\u0016\u000f[A\u0011afN\u0007\u0002_)\u0011\u0001'M\u0001\u0006g24GG\u001b\u0006\u0003eM\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001N\u001b\u0002\u0011QL\b/Z:bM\u0016T\u0011AN\u0001\u0004G>l\u0017B\u0001\u001d0\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011iZ#Q1A\u0005\u0002m\nQ\u0001\u001d#bi\u0006,\u0012\u0001\u0010\t\u0003{yj\u0011\u0001B\u0005\u0003\u007f\u0011\u00111\u0002\u0015:pU\u0016\u001cG\u000fR1uC\"A\u0011i\u000bB\u0001B\u0003%A(\u0001\u0004q\t\u0006$\u0018\r\t\u0005\t\u0007.\u0012)\u0019!C\u0001\t\u0006A\u0001/\u0019:us&#7/F\u0001F!\ryaIG\u0005\u0003\u000fB\u0011Q!\u0011:sCfD\u0001\"S\u0016\u0003\u0002\u0003\u0006I!R\u0001\na\u0006\u0014H/_%eg\u0002B\u0001bS\u0016\u0003\u0002\u0003\u0006I\u0001T\u0001\fa\u0006\u0014H/\u001f)be\u0006l7\u000f\u0005\u0002\u000b\u001b&\u0011aJ\u0001\u0002\u0010!\u0006\u0014H/\u001f)be\u0006lW\r^3sg\"A\u0001k\u000bBC\u0002\u0013\u0005\u0011+A\u0005f]\u000e|WO\u001c;feV\t!\u000b\u0005\u0002>'&\u0011A\u000b\u0002\u0002\n\u000b:\u001cw.\u001e8uKJD\u0001BV\u0016\u0003\u0002\u0003\u0006IAU\u0001\u000bK:\u001cw.\u001e8uKJ\u0004\u0003\u0002\u0003-,\u0005\u0003\u0005\u000b\u0011B-\u0002\u000b\u0005Lw\n\u001d;\u0011\u0007=QF,\u0003\u0002\\!\t1q\n\u001d;j_:\u0004\"AC/\n\u0005y\u0013!\u0001\u0003\"biRdW-Q%\t\u000bUYC\u0011\u00011\u0015\r\u0005\u00147\rZ3g!\tQ1\u0006C\u0003;?\u0002\u0007A\bC\u0003D?\u0002\u0007Q\tC\u0003L?\u0002\u0007A\nC\u0003Q?\u0002\u0007!\u000bC\u0003Y?\u0002\u0007\u0011\fC\u0004iW\u0001\u0007I\u0011B5\u0002\u000b}#\u0018.\\3\u0016\u0003)\u0004\"aD6\n\u00051\u0004\"!\u0002$m_\u0006$\bb\u00028,\u0001\u0004%Ia\\\u0001\n?RLW.Z0%KF$\"\u0001]:\u0011\u0005=\t\u0018B\u0001:\u0011\u0005\u0011)f.\u001b;\t\u000fQl\u0017\u0011!a\u0001U\u0006\u0019\u0001\u0010J\u0019\t\rY\\\u0003\u0015)\u0003k\u0003\u0019yF/[7fA!)\u0001p\u000bC\u0001S\u0006!A/[7f\u0011\u001dQ8\u00061A\u0005\ne\taaX:uCR,\u0007b\u0002?,\u0001\u0004%I!`\u0001\u000b?N$\u0018\r^3`I\u0015\fHC\u00019\u007f\u0011\u001d!80!AA\u0002iAq!!\u0001,A\u0003&!$A\u0004`gR\fG/\u001a\u0011\t\r\u0005\u00151\u0006\"\u0001\u001a\u0003\u0015\u0019H/\u0019;f\u0011%\tIa\u000ba\u0001\n\u0003\tY!\u0001\ntGJL\u0007\u000f\u001e'bgR,\u00050Z2vi\u0016$WCAA\u0007!\ryaI\u001b\u0005\n\u0003#Y\u0003\u0019!C\u0001\u0003'\tac]2sSB$H*Y:u\u000bb,7-\u001e;fI~#S-\u001d\u000b\u0004a\u0006U\u0001\"\u0003;\u0002\u0010\u0005\u0005\t\u0019AA\u0007\u0011!\tIb\u000bQ!\n\u00055\u0011aE:de&\u0004H\u000fT1ti\u0016CXmY;uK\u0012\u0004\u0003bBA\u000fW\u0011%\u0011qD\u0001\f?\u0016tW-\\=ECR\f7/\u0006\u0002\u0002\"A!qBRA\u0012!\ri\u0014QE\u0005\u0004\u0003O!!!B#oK6L\bBBA\u0016W\u0011\u0005\u0011$A\twS\u000e$xN]=FqB,'/[3oG\u0016Da!a\f,\t\u0003I\u0012!C4pY\u0012$%o\u001c9t\u0011\u001d\t\u0019d\u000bC\u0001\u0003k\t\u0011cZ3oKJ\fG/Z%uK6$%o\u001c9t)\t\t9\u0004E\u0003\u0002:\u0005\r#$\u0004\u0002\u0002<)!\u0011QHA \u0003\u001diW\u000f^1cY\u0016T1!!\u0011\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\nYDA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0002CA%W\t\u0007I\u0011A5\u0002\u0019\t\f7/\u001a+ve:$\u0016.\\3\t\u000f\u000553\u0006)A\u0005U\u0006i!-Y:f)V\u0014h\u000eV5nK\u0002B\u0011\"!\u0015,\u0001\u0004%I!a\u0015\u0002\u001d}sw\u000e^5gS\u000e\fG/[8ogV\u0011\u0011Q\u000b\t\u0007\u0003s\t9&a\u0017\n\t\u0005e\u00131\b\u0002\u0006#V,W/\u001a\t\u0004\u0015\u0005u\u0013bAA0\u0005\tA\")\u0019;uY\u0016\f5\r^5p]:{G/\u001b4jG\u0006$\u0018n\u001c8\t\u0013\u0005\r4\u00061A\u0005\n\u0005\u0015\u0014AE0o_RLg-[2bi&|gn]0%KF$2\u0001]A4\u0011%!\u0018\u0011MA\u0001\u0002\u0004\t)\u0006\u0003\u0005\u0002l-\u0002\u000b\u0015BA+\u0003=yfn\u001c;jM&\u001c\u0017\r^5p]N\u0004\u0003bBA8W\u0011\u0005\u0011\u0011O\u0001\u0010O\u0016$hj\u001c;jM&\u001c\u0017\r^5p]V\u0011\u00111\u000f\t\u0005\u001fi\u000bY\u0006C\u0004\u0002x-\"\t!!\u001f\u0002'\u0011L7/\\5tg:{G/\u001b4jG\u0006$\u0018n\u001c8\u0015\u0005\u0005m\u0003\"CA?W\t\u0007I\u0011BA@\u0003-\t7\r^5p]F+X-^3\u0016\u0005\u0005\u0005\u0005CBA\u001d\u0003/\n\u0019\tE\u0002\u000b\u0003\u000bK1!a\"\u0003\u00051\u0011\u0015\r\u001e;mK\u0006\u001bG/[8o\u0011!\tYi\u000bQ\u0001\n\u0005\u0005\u0015\u0001D1di&|g.U;fk\u0016\u0004\u0003\"CAHW\t\u0007I\u0011BAI\u0003)\u0011X-\u00193z#V,W/Z\u000b\u0003\u0003'\u0003b!!\u000f\u0002X\u0005U\u0005c\u0001\u0006\u0002\u0018&\u0019\u0011\u0011\u0014\u0002\u0003\u0019\t\u000bG\u000f\u001e7f'R\fG/^:\t\u0011\u0005u5\u0006)A\u0005\u0003'\u000b1B]3bIf\fV/Z;fA!9\u0011\u0011U\u0016\u0005\u0002\u0005\r\u0016a\u0003:fC\u0012LXI\u001c;jif,\"!!*\u0011\t=Q\u0016Q\u0013\u0005\b\u0003S[C\u0011AAI\u00031\u0011X-\u00193z\u000b:,W.[3t\u0011\u001d\tik\u000bC\u0001\u0003_\u000b!\u0002^1lK\u0006\u001bG/[8o)\r\u0001\u0018\u0011\u0017\u0005\t\u0003g\u000bY\u000b1\u0001\u0002\u0004\u00061\u0011m\u0019;j_:D\u0011\"a.,\u0005\u0004%\t!!/\u0002\u0017A\f'\u000f^=Ti\u0006$Xo]\u000b\u0003\u0003w\u0003Ba\u0004$\u0002\u0016\"A\u0011qX\u0016!\u0002\u0013\tY,\u0001\u0007qCJ$\u0018p\u0015;biV\u001c\b\u0005C\u0005\u0002D.\u0012\r\u0011\"\u0001\u0002:\u0006YQM\\3nsN#\u0018\r^;t\u0011!\t9m\u000bQ\u0001\n\u0005m\u0016\u0001D3oK6L8\u000b^1ukN\u0004\u0003\"CAfW\t\u0007I\u0011AA]\u0003%\tG\u000e\\*uCR,8\u000f\u0003\u0005\u0002P.\u0002\u000b\u0011BA^\u0003)\tG\u000e\\*uCR,8\u000f\t\u0005\b\u0003'\\C\u0011AAk\u00035\tG\u000f^3naR,5oY1qKR\u0011\u0011q\u001b\t\u0004\u001f\u0005e\u0017bAAn!\t9!i\\8mK\u0006t\u0007bBApW\u0011\u0005\u0011\u0011]\u0001\u000ee\u0006tGm\\7BY&4Xm\u00144\u0015\t\u0005\u0015\u00161\u001d\u0005\t\u0003K\fi\u000e1\u0001\u0002h\u0006QQM\u001c;jif$\u0016\u0010]3\u0011\t\u0005%\u0018q\u001e\b\u0004\u0015\u0005-\u0018bAAw\u0005\u0005\u0001\")\u0019;uY\u0016,e\u000e^5usRK\b/Z\u0005\u0005\u0003c\f\u0019PA\u0003WC2,X-C\u0002\u0002vB\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\"9\u0011\u0011`\u0016\u0005\u0002\u0005m\u0018aC1em\u0006t7-\u001a+j[\u0016$2\u0001]A\u007f\u0011\u001d\ty0a>A\u0002)\fA\u0002Z3mi\u0006\u001cVmY8oIN\u0004")
public class Battle
implements LazyLogging {
    private final ProjectData pData;
    private final int[] partyIds;
    public final PartyParameters rpgboss$model$battle$Battle$$partyParams;
    private final Encounter encounter;
    private final Option<BattleAI> aiOpt;
    private float _time;
    private int _state;
    private float[] scriptLastExecuted;
    private final float baseTurnTime;
    private Queue<BattleActionNotification> _notifications;
    private final Queue<BattleAction> rpgboss$model$battle$Battle$$actionQueue;
    private final Queue<BattleStatus> rpgboss$model$battle$Battle$$readyQueue;
    private final BattleStatus[] partyStatus;
    private final BattleStatus[] enemyStatus;
    private final BattleStatus[] allStatus;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static int ESCAPED() {
        return Battle$.MODULE$.ESCAPED();
    }

    public static int DEFEAT() {
        return Battle$.MODULE$.DEFEAT();
    }

    public static int VICTORY() {
        return Battle$.MODULE$.VICTORY();
    }

    public static int ACTIVE() {
        return Battle$.MODULE$.ACTIVE();
    }

    private Logger logger$lzycompute() {
        Battle battle = this;
        synchronized (battle) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public ProjectData pData() {
        return this.pData;
    }

    public int[] partyIds() {
        return this.partyIds;
    }

    public Encounter encounter() {
        return this.encounter;
    }

    private float _time() {
        return this._time;
    }

    private void _time_$eq(float x$1) {
        this._time = x$1;
    }

    public float time() {
        return this._time();
    }

    private int _state() {
        return this._state;
    }

    private void _state_$eq(int x$1) {
        this._state = x$1;
    }

    public int state() {
        return this._state();
    }

    public float[] scriptLastExecuted() {
        return this.scriptLastExecuted;
    }

    public void scriptLastExecuted_$eq(float[] x$1) {
        this.scriptLastExecuted = x$1;
    }

    private Enemy[] _enemyDatas() {
        return (Enemy[])Predef$.MODULE$.refArrayOps((Object[])this.enemyStatus()).map(new Serializable(this){
            private final /* synthetic */ Battle $outer;

            public final Enemy apply(BattleStatus status) {
                return this.$outer.pData().enums().enemies()[status.entityId()];
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Enemy.class)));
    }

    public int victoryExperience() {
        return BoxesRunTime.unboxToInt(Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])this._enemyDatas()).map(new Serializable(this){

            public final int apply(Enemy x$1) {
                return x$1.expValue();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum(Numeric$IntIsIntegral$.MODULE$));
    }

    public int goldDrops() {
        return BoxesRunTime.unboxToInt(Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])this._enemyDatas()).map(new Serializable(this){

            public final int apply(Enemy x$2) {
                return x$2.droppedGold();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum(Numeric$IntIsIntegral$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer<Object> generateItemDrops() {
        void var1_1;
        ArrayBuffer droppedItemIds = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this._enemyDatas()).foreach(new Serializable(this, droppedItemIds){
            private final /* synthetic */ Battle $outer;
            private final ArrayBuffer droppedItemIds$1;

            public final void apply(Enemy enemy) {
                BoxedUnit boxedUnit;
                float totalChanceDrop = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])enemy.droppedItems()).map(new Serializable(this){

                    public final float apply(ItemDrop x$3) {
                        return x$3.chance();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).sum(Numeric$FloatIsFractional$.MODULE$));
                if (totalChanceDrop > 1.0f) {
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn(new StringOps(Predef$.MODULE$.augmentString("Enemy \"%s\" has a %f%% chance of dropping items.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{enemy.name(), BoxesRunTime.boxToFloat(totalChanceDrop * (float)100)})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (package$.MODULE$.random() < (double)totalChanceDrop) {
                    this.droppedItemIds$1.append(Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt(Utils$.MODULE$.randomChoose(Predef$.MODULE$.refArrayOps((Object[])enemy.droppedItems()).map(new Serializable(this){

                        public final int apply(ItemDrop x$4) {
                            return x$4.itemId();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), (float[])Predef$.MODULE$.refArrayOps((Object[])enemy.droppedItems()).map(new Serializable(this){

                        public final float apply(ItemDrop x$5) {
                            return x$5.chance();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))))}));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.droppedItemIds$1 = droppedItemIds$1;
            }
        });
        return var1_1;
    }

    public float baseTurnTime() {
        return this.baseTurnTime;
    }

    private Queue<BattleActionNotification> _notifications() {
        return this._notifications;
    }

    private void _notifications_$eq(Queue<BattleActionNotification> x$1) {
        this._notifications = x$1;
    }

    public Option<BattleActionNotification> getNotification() {
        return this._notifications().headOption();
    }

    public BattleActionNotification dismissNotification() {
        return this._notifications().dequeue();
    }

    public Queue<BattleAction> rpgboss$model$battle$Battle$$actionQueue() {
        return this.rpgboss$model$battle$Battle$$actionQueue;
    }

    public Queue<BattleStatus> rpgboss$model$battle$Battle$$readyQueue() {
        return this.rpgboss$model$battle$Battle$$readyQueue;
    }

    public Option<BattleStatus> readyEntity() {
        return this.rpgboss$model$battle$Battle$$readyQueue().headOption();
    }

    public Queue<BattleStatus> readyEnemies() {
        return (Queue)this.rpgboss$model$battle$Battle$$readyQueue().filter((Function1)((Object)new Serializable(this){

            public final boolean apply(BattleStatus x$6) {
                Enumeration.Value value2 = x$6.entityType();
                Enumeration.Value value3 = BattleEntityType$.MODULE$.Enemy();
                return !(value2 != null ? !((Object)value2).equals(value3) : value3 != null);
            }
        }));
    }

    public void takeAction(BattleAction action2) {
        Option<BattleStatus> dequeued = this.rpgboss$model$battle$Battle$$readyQueue().dequeueFirst((Function1<BattleStatus, Object>)((Object)new Serializable(this, action2){
            private final BattleAction action$1;

            public final boolean apply(BattleStatus x$7) {
                BattleStatus battleStatus = x$7;
                BattleStatus battleStatus2 = this.action$1.actor();
                return !(battleStatus != null ? !battleStatus.equals(battleStatus2) : battleStatus2 != null);
            }
            {
                this.action$1 = action$1;
            }
        }));
        if (dequeued.isEmpty()) {
            return;
        }
        this.rpgboss$model$battle$Battle$$actionQueue().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new BattleAction[]{action2}));
        action2.actor().readiness_$eq(0.0);
    }

    public BattleStatus[] partyStatus() {
        return this.partyStatus;
    }

    public BattleStatus[] enemyStatus() {
        return this.enemyStatus;
    }

    public BattleStatus[] allStatus() {
        return this.allStatus;
    }

    public boolean attemptEscape() {
        if (this.encounter().canEscape() && package$.MODULE$.random() < (double)this.encounter().escapeChance()) {
            this._state_$eq(Battle$.MODULE$.ESCAPED());
            return true;
        }
        return false;
    }

    public Option<BattleStatus> randomAliveOf(Enumeration.Value entityType) {
        BattleStatus[] battleStatusArray;
        Enumeration.Value value2 = entityType;
        Enumeration.Value value3 = BattleEntityType$.MODULE$.Enemy();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            battleStatusArray = (BattleStatus[])Predef$.MODULE$.refArrayOps((Object[])this.enemyStatus()).filter(new Serializable(this){

                public final boolean apply(BattleStatus x$12) {
                    return x$12.alive();
                }
            });
        } else {
            Enumeration.Value value5 = BattleEntityType$.MODULE$.Party();
            Enumeration.Value value6 = value2;
            battleStatusArray = !(value5 != null ? !((Object)value5).equals(value6) : value6 != null) ? (BattleStatus[])Predef$.MODULE$.refArrayOps((Object[])this.partyStatus()).filter(new Serializable(this){

                public final boolean apply(BattleStatus x$13) {
                    return x$13.alive();
                }
            }) : (BattleStatus[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        }
        BattleStatus[] aliveList = battleStatusArray;
        return Predef$.MODULE$.refArrayOps((Object[])aliveList).isEmpty() ? None$.MODULE$ : new Some<BattleStatus>(aliveList[Random$.MODULE$.nextInt(aliveList.length)]);
    }

    public void advanceTime(float deltaSeconds) {
        Tuple2<Hit[], Object> tuple2;
        block9: {
            block8: {
                Tuple2<Hit[], Boolean> tuple22;
                if (this._state() != Battle$.MODULE$.ACTIVE()) {
                    return;
                }
                this._time_$eq(this._time() + deltaSeconds);
                boolean ticked = this._time() % this.baseTurnTime() <= deltaSeconds;
                Hit[][] statusEffectHits = (Hit[][])Predef$.MODULE$.refArrayOps((Object[])this.allStatus()).map(new Serializable(this, deltaSeconds, ticked){
                    private final /* synthetic */ Battle $outer;
                    private final float deltaSeconds$1;
                    private final boolean ticked$1;

                    public final Hit[] apply(BattleStatus status) {
                        boolean pendingAction = this.$outer.rpgboss$model$battle$Battle$$actionQueue().exists((Function1<BattleAction, Object>)((Object)new Serializable(this, status){
                            private final BattleStatus status$1;

                            public final boolean apply(BattleAction x$14) {
                                BattleStatus battleStatus = x$14.actor();
                                BattleStatus battleStatus2 = this.status$1;
                                return !(battleStatus != null ? !battleStatus.equals(battleStatus2) : battleStatus2 != null);
                            }
                            {
                                this.status$1 = status$1;
                            }
                        }));
                        return status.update(pendingAction, this.deltaSeconds$1, this.$outer.baseTurnTime(), this.ticked$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.deltaSeconds$1 = deltaSeconds$1;
                        this.ticked$1 = ticked$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Hit.class))));
                Hit[] flattenedStatusEffectHits = (Hit[])Predef$.MODULE$.refArrayOps((Object[])statusEffectHits).flatten(new Serializable(this){

                    public final WrappedArray<Hit> apply(Hit[] xs) {
                        return Predef$.MODULE$.wrapRefArray((Object[])xs);
                    }
                }, ClassTag$.MODULE$.apply(Hit.class));
                if (!Predef$.MODULE$.refArrayOps((Object[])flattenedStatusEffectHits).isEmpty()) {
                    this._notifications().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new BattleActionNotification[]{new BattleActionNotification(StatusEffectAction$.MODULE$, flattenedStatusEffectHits, true)}));
                }
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.allStatus()).filter(new Serializable(this){

                    public final boolean apply(BattleStatus x$15) {
                        return x$15.readiness() >= 1.0;
                    }
                })).sortBy(new Serializable(this){

                    public final double apply(BattleStatus x$16) {
                        return -x$16.readiness();
                    }
                }, Ordering$Double$.MODULE$)).filter(new Serializable(this){
                    private final /* synthetic */ Battle $outer;

                    public final boolean apply(BattleStatus x$17) {
                        return !this.$outer.rpgboss$model$battle$Battle$$readyQueue().contains(x$17);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).foreach(new Serializable(this){
                    private final /* synthetic */ Battle $outer;

                    public final void apply(BattleStatus x$18) {
                        this.$outer.rpgboss$model$battle$Battle$$readyQueue().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new BattleStatus[]{x$18}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.aiOpt.map(new Serializable(this){
                    private final /* synthetic */ Battle $outer;

                    public final void apply(BattleAI x$19) {
                        x$19.update(this.$outer);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.rpgboss$model$battle$Battle$$actionQueue().isEmpty()) break block8;
                BattleAction action2 = this.rpgboss$model$battle$Battle$$actionQueue().dequeue();
                tuple2 = action2.process(this);
                if (tuple2 == null) break block9;
                Hit[] hits = tuple2._1();
                boolean success2 = tuple2._2$mcZ$sp();
                Tuple2<Hit[], Boolean> tuple23 = tuple22 = new Tuple2<Hit[], Boolean>(hits, BoxesRunTime.boxToBoolean(success2));
                Hit[] hits2 = tuple23._1();
                boolean success3 = tuple23._2$mcZ$sp();
                this._notifications().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new BattleActionNotification[]{new BattleActionNotification(action2, hits2, success3)}));
            }
            this.rpgboss$model$battle$Battle$$readyQueue().dequeueAll((Function1<BattleStatus, Object>)((Object)new Serializable(this){

                public final boolean apply(BattleStatus x$21) {
                    return !x$21.alive();
                }
            }));
            if (Predef$.MODULE$.refArrayOps((Object[])this.partyStatus()).forall(new Serializable(this){

                public final boolean apply(BattleStatus x$22) {
                    return !x$22.alive();
                }
            })) {
                this._state_$eq(Battle$.MODULE$.DEFEAT());
                this.rpgboss$model$battle$Battle$$readyQueue().clear();
            } else if (Predef$.MODULE$.refArrayOps((Object[])this.enemyStatus()).forall(new Serializable(this){

                public final boolean apply(BattleStatus x$23) {
                    return !x$23.alive();
                }
            })) {
                this._state_$eq(Battle$.MODULE$.VICTORY());
                this.rpgboss$model$battle$Battle$$readyQueue().clear();
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public Battle(ProjectData pData, int[] partyIds, PartyParameters partyParams, Encounter encounter, Option<BattleAI> aiOpt) {
        this.pData = pData;
        this.partyIds = partyIds;
        this.rpgboss$model$battle$Battle$$partyParams = partyParams;
        this.encounter = encounter;
        this.aiOpt = aiOpt;
        LazyLogging$class.$init$(this);
        Predef$.MODULE$.require(Predef$.MODULE$.intArrayOps(partyIds).forall(new Serializable(this){
            private final /* synthetic */ Battle $outer;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return i >= 0 && i < this.$outer.pData().enums().characters().length;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])encounter.units()).forall(new Serializable(this){
            private final /* synthetic */ Battle $outer;

            public final boolean apply(EncounterUnit unit2) {
                return unit2.enemyIdx() >= 0 && unit2.enemyIdx() < this.$outer.pData().enums().enemies().length;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this._time = 0.0f;
        this._state = Battle$.MODULE$.ACTIVE();
        this.scriptLastExecuted = (float[])Array$.MODULE$.fill(encounter.events().length, new Serializable(this){

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return Float$.MODULE$.MinValue();
            }
        }, ClassTag$.MODULE$.Float());
        this.baseTurnTime = 4.0f;
        this._notifications = (Queue)Queue$.MODULE$.apply(Nil$.MODULE$);
        this.rpgboss$model$battle$Battle$$actionQueue = new Queue();
        this.rpgboss$model$battle$Battle$$readyQueue = new Queue();
        this.partyStatus = (BattleStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(partyIds).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter(new Serializable(this){

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map(new Serializable(this){
            private final /* synthetic */ Battle $outer;

            public final BattleStatus apply(Tuple2<Object, Object> x$8) {
                Tuple2<Object, Object> tuple2 = x$8;
                if (tuple2 != null) {
                    int characterId = tuple2._1$mcI$sp();
                    int index2 = tuple2._2$mcI$sp();
                    BattleStatus battleStatus = BattleStatus$.MODULE$.fromCharacter(this.$outer.pData(), this.$outer.rpgboss$model$battle$Battle$$partyParams, characterId, index2);
                    return battleStatus;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BattleStatus.class)));
        this.enemyStatus = (BattleStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])encounter.units()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter(new Serializable(this){

            public final boolean apply(Tuple2<EncounterUnit, Object> check$ifrefutable$2) {
                Tuple2<EncounterUnit, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map(new Serializable(this){
            private final /* synthetic */ Battle $outer;

            public final BattleStatus apply(Tuple2<EncounterUnit, Object> x$9) {
                Tuple2<EncounterUnit, Object> tuple2 = x$9;
                if (tuple2 != null) {
                    EncounterUnit unit2 = tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Enemy enemy = this.$outer.pData().enums().enemies()[unit2.enemyIdx()];
                    BaseStats baseStats = enemy.baseStats();
                    int row = i * 2 / this.$outer.encounter().units().length;
                    BattleStatus battleStatus = new BattleStatus(i, this.$outer.pData(), BattleEntityType$.MODULE$.Enemy(), unit2.enemyIdx(), baseStats.mhp(), baseStats.mmp(), baseStats, (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), new int[]{enemy.attackSkillId()}, enemy.skillIds(), (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), row);
                    return battleStatus;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BattleStatus.class)));
        this.allStatus = (BattleStatus[])Predef$.MODULE$.refArrayOps((Object[])this.partyStatus()).$plus$plus(Predef$.MODULE$.refArrayOps((Object[])this.enemyStatus()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BattleStatus.class)));
        BattleStatus[] slowestToFastest = (BattleStatus[])Predef$.MODULE$.refArrayOps((Object[])this.allStatus()).sortBy(new Serializable(this){

            public final int apply(BattleStatus x$10) {
                return x$10.stats().spd();
            }
        }, Ordering$Int$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])slowestToFastest).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter(new Serializable(this){

            public final boolean apply(Tuple2<BattleStatus, Object> check$ifrefutable$3) {
                Tuple2<BattleStatus, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach(new Serializable(this, slowestToFastest){
            private final BattleStatus[] slowestToFastest$1;

            public final void apply(Tuple2<BattleStatus, Object> x$11) {
                Tuple2<BattleStatus, Object> tuple2 = x$11;
                if (tuple2 != null) {
                    BattleStatus status = tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    status.readiness_$eq((double)i / (double)(this.slowestToFastest$1.length - 1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.slowestToFastest$1 = slowestToFastest$1;
            }
        });
        this.advanceTime(0.0f);
    }
}

